CREATE OR REPLACE FUNCTION addView() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	
	IF EXISTS (SELECT 1 FROM pg_views  WHERE viewname = 'v_recebimento_crediario') THEN 
		DROP VIEW IF EXISTS v_recebimento_crediario;
        RAISE NOTICE 'v_recebimento_crediario removida.';
    END IF; 
	

CREATE OR REPLACE VIEW public.v_recebimento_crediario
AS SELECT cupom.cd_emp,
    cupom.cd_filial,
    cupom.cd_cx,
    cupom.dt_cupom,
    cupom.dt_cad,
    cupom.dt_cad AS hr_cupom,
    cupom.tp_cupom_nao_fiscal AS tp_cupom,
    fatura.nrfatura,
    fatura.dt_vencto,
    fatura.cd_ctr_pgto,
    0 AS cd_ctr_pgto_parcela,
    cupom.cd_mov,
    cupom.cd_ctr,
    cupom.nr_coo,
    cupom.st_cupom,
    cupom.cont_cupom_fisc AS contador_cupom_fiscal,
    cupom.cd_mov AS codigo_movimento,
    cupom.vlr_to_cupom AS vlr_tot_cupom,
    cupom.vlr_dinh,
    cupom.vlr_cartao,
    cupom.vlr_chqs_a_vista + cupom.vlr_chqs_a_prz AS vlr_chqs,
    cupom.nr_serie_imp AS nr_serie_ecf,
    cupom.vs_pdv AS versao_pdv,
    cupom.vs_pdv_rc AS versao_pdv_rc,
    NULLIF(COALESCE(cupom.vlr_dinh, 0::numeric) <> 0::numeric, false) AS contem_dinheiro,
    NULLIF(cupom.st_cupom <> 0::numeric, false) AS is_cancelado,
    cupom.tp_cupom_nao_fiscal = 0::numeric AS is_fatura,
    cupom.cd_ctr AS doacao_id,
    COALESCE(fatura.cd_ctr_pgto) AS fatura_rec_id,
    fatura.cd_rc_deb AS fatura_id,
    fatura.vlr_sld_dp AS fatura_vlr,
    fatura.vlr_min_pgto AS fatura_vlr_min,
    fatura.vlr_pago AS fatura_vlr_cred,
    fatura.vlrdesconto AS vlr_desc,
    fatura.vlrjuros,
    fatura.vlr_origin_fatura AS vlr_original,
    0 AS parcela_id,
    0 AS parcela_vlr,
    0 AS parcela_vlr_cred,
    0 AS st_vd,
    cupom.hash_protocolo,
    cupom.st_pend_estorno,
    fatura.tp_pgto_offline,
    0 AS tp_pgto_offline_parcela,
    fatura.filial_origem,
    fatura.dt_lancto,
    fatura.nrdoc,
    fatura.cd_rc_deb,
    fatura.vlr_pago,
    0 AS vlr_pago_parc,
    cupom.cd_usu,
    0 AS tp_reg,
    cupom.cd_cli,
    cupom.vlr_troco 
   FROM pdv_cupom_nao_fiscal_rec_fatura fatura
     JOIN pdv_cupom_nao_fiscal cupom ON fatura.cd_emp = cupom.cd_emp AND fatura.cd_filial = cupom.cd_filial AND fatura.cd_cx = cupom.cd_cx AND fatura.cd_ctr = cupom.cd_ctr
UNION
 SELECT cupom.cd_emp,
    cupom.cd_filial,
    cupom.cd_cx,
    cupom.dt_cupom,
    cupom.dt_cad,
    cupom.dt_cad AS hr_cupom,
    cupom.tp_cupom_nao_fiscal AS tp_cupom,
    '0'::character varying AS nrfatura,
    ( SELECT now() AS now) AS dt_vencto,
    0 AS cd_ctr_pgto,
    parcela.cd_ctr_pgto AS cd_ctr_pgto_parcela,
    cupom.cd_mov,
    cupom.cd_ctr,
    cupom.nr_coo,
    cupom.st_cupom,
    cupom.cont_cupom_fisc AS contador_cupom_fiscal,
    cupom.cd_mov AS codigo_movimento,
    cupom.vlr_to_cupom AS vlr_tot_cupom,
    cupom.vlr_dinh,
    cupom.vlr_cartao,
    cupom.vlr_chqs_a_vista + cupom.vlr_chqs_a_prz AS vlr_chqs,
    cupom.nr_serie_imp AS nr_serie_ecf,
    cupom.vs_pdv AS versao_pdv,
    cupom.vs_pdv_rc AS versao_pdv_rc,
    NULLIF(COALESCE(cupom.vlr_dinh, 0::numeric) <> 0::numeric, false) AS contem_dinheiro,
    NULLIF(cupom.st_cupom <> 0::numeric, false) AS is_cancelado,
    cupom.tp_cupom_nao_fiscal = 0::numeric AS is_fatura,
    cupom.cd_ctr AS doacao_id,
    COALESCE(parcela.cd_ctr_pgto) AS fatura_rec_id,
    0 AS fatura_id,
    0 AS fatura_vlr,
    0 AS fatura_vlr_min,
    0 AS fatura_vlr_cred,
    0 AS vlr_desc,
    0 AS vlrjuros,
    0 AS vlr_original,
    parcela.cd_ctr_parc AS parcela_id,
    parcela.vlr_parc AS parcela_vlr,
    parcela.vlr_pago AS parcela_vlr_cred,
    0 AS st_vd,
    cupom.hash_protocolo,
    cupom.st_pend_estorno,
    0 AS tp_pgto_offline,
    parcela.tp_pgto_offline AS tp_pgto_offline_parcela,
    0 AS filial_origem,
    ( SELECT now() AS now) AS dt_lancto,
    ''::character varying AS nrdoc,
    0 AS cd_rc_deb,
    0 AS vlr_pago,
    parcela.vlr_pago AS vlr_pago_parc,
    cupom.cd_usu,
    1 AS tp_reg,
    cupom.cd_cli,
    cupom.vlr_troco
   FROM pdv_cupom_nao_fiscal_rec_parc_cred parcela
     JOIN pdv_cupom_nao_fiscal cupom ON parcela.cd_emp = cupom.cd_emp AND parcela.cd_filial = cupom.cd_filial AND parcela.cd_cx = cupom.cd_cx AND parcela.cd_ctr = cupom.cd_ctr;


ALTER TABLE public.v_recebimento_crediario    OWNER TO postgres;



	RAISE NOTICE 'View v_recebimento_crediario recriada.'; 
       
END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addView() OWNER TO postgres; 
SELECT addView(); 
DROP FUNCTION addView();
	